// SC2A0Dlg.h : header file
//

#if !defined(AFX_SC2A0DLG_H__B049E8F3_88C1_4C77_B9B4_EDE24614DE52__INCLUDED_)
#define AFX_SC2A0DLG_H__B049E8F3_88C1_4C77_B9B4_EDE24614DE52__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/////////////////////////////////////////////////////////////////////////////
// CSC2A0Dlg dialog

#include "ChannelWindow.h"

#include "SetupDialog.h"

#include "TabCtrlEx.h"

class CSC2A0Dlg : public CDialog
{
// Construction
public:
	CSC2A0Dlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CSC2A0Dlg)
	enum { IDD = IDD_SC2A0_DIALOG };
	CTabCtrlEx	m_tabDisplayExchange;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CSC2A0Dlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CSC2A0Dlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	virtual void OnCancel();
	virtual void OnOK();
	afx_msg void OnSelChangeTabDisplay(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnDestroy();
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

public:

	// USER INTERFACE FUNCTION 
	//
	BOOL				OnLButtonDown_ChannelWindow( ULONG nChannelNumber, UINT nFlags, CPoint Point );

	BOOL				OnLButtonUp_ChannelWindow( ULONG nChannelNumber, UINT nFlags, CPoint Point );

	BOOL				OnApply_SetupDialog();

	BOOL				OnSnapshot_SetupDialog();

	BOOL				OnSync_SetupDialog();

	BOOL				OnFileSourceDestroy_FileManagerWindow( ULONG nChannelNumber );

	BOOL				OnFileSourceCreate_FileManagerWindow( ULONG nChannelNumber, AMESDK_FILE_INFO * pFileInfo );

	BOOL				OnFileSourceRun_FileManagerWindow( ULONG nChannelNumber );

	BOOL				OnFileSourcePause_FileManagerWindow( ULONG nChannelNumber );

	BOOL				OnFileSourceStop_FileManagerWindow( ULONG nChannelNumber );

	BOOL				OnFileSourceStep_FileManagerWindow( ULONG nChannelNumber, ULONG nSteps );

	BOOL				OnFileSourceGetVideoStreamBuffer_FileManagerWindow( ULONG nChannelNumber, ULONG nSample, BYTE * pStreamBuffer, ULONG * pStreamBufferSize );

	BOOL				OnFileSourceGetAudioStreamBuffer_FileManagerWindow( ULONG nChannelNumber, ULONG nSample, BYTE * pStreamBuffer, ULONG * pStreamBufferSize );

	BOOL				OnFileSourceGetVideoStreamData_FileManagerWindow( ULONG nChannelNumber, ULONG nSample, ULONGLONG * pTimeStamp, BOOL * pIsKeyFrame );

	BOOL				OnFileSourceGetAudioStreamData_FileManagerWindow( ULONG nChannelNumber, ULONG nSample, ULONGLONG * pTimeStamp );
	
	LONGLONG			OnFileSourceGetMediaLength_FileManagerWindow( ULONG nChannelNumber, DWORD dwTimeUnits );

	LONGLONG			OnFileSourceGetMediaPosition_FileManagerWindow( ULONG nChannelNumber, DWORD dwTimeUnits );

	BOOL				OnFileSourceSetMediaPosition_FileManagerWindow( ULONG nChannelNumber, LONGLONG nPosition, DWORD dwTimeUnits );

	double				OnFileSourceGetMediaPlaybackRate_FileManagerWindow( ULONG nChannelNumber );

	BOOL				OnFileSourceSetMediaPlaybackRate_FileManagerWindow( ULONG nChannelNumber, double dRate );

	// DEVICE FUNCTION
	// 
	BOOL				HwUnInitialize();

	BOOL				HwInitialize();

	// USER INTERFACE PROPERTY
	// 
	CChannelWindow		m_oChannelWindow_LIVE[ 4 ];						//  LIVE STREAM DISPLAY WINDOW

	CChannelWindow		m_oChannelWindow_FILE[ 4 ];						//  FILE STREAM DISPLAY WINDOW (RECORD PLAYBACK)

	CChannelWindow		m_oChannelWindow_H264_MAIN[ 4 ];				//  H.264 MAIN.STREAM DISPLAY WINDOW (REALTIME PLAYBACK)

	CChannelWindow		m_oChannelWindow_H264_SUB[ 4 ];					//  H.264 SUB.STREAM DISPLAY WINDOW (REALTIME PLAYBACK)

	CSetupDialog		m_oSetupDialog;									//  PARAMETER SETUP DIALOG

	ULONG				m_nDisplayModeNumber;							//  DISPLAY MODE EXCHANGE (0 = LIVE / 1 = RCPB / 2 = RTPB / 3 = RTPB)

	// DEVICE PROPERTY
	// 
	DEVICE_HANDLE		m_hVideoDev[ 4 ];								// VIDEO STREAM CAPTURE DEVICE

	DEVICE_HANDLE		m_hVideoMainEncoderDev[ 4 ];					// H.264 MAIN.STREAM CAPTURE DEVICE

	DEVICE_HANDLE		m_hVideoSubEncoderDev[ 4 ];						// H.264 SUB.STREAM CAPTURE DEVICE

	DEVICE_HANDLE		m_hAudioDev[ 4 ];								// AUDIO STREAM CAPTURE DEVICE 

	DEVICE_HANDLE		m_hAudioAACEncoderDev[ 4 ];						// AUDIO AAC SOFTWARE ENCODER DEVICE 

	// FILE PROPERTY
	// 
	DEVICE_HANDLE		m_hFileRendererDev[ 4 ];						// FILE RENDERER DEVICE

	ULONG				m_nFileRendererRecordState[ 4 ];				// FILE RENDERER RECORD STATE (0 = STOP / 1 = ACQUIRE / 2 = START)

	DEVICE_HANDLE		m_hFileSourceDev[ 4 ];							// FILE SOURCE DEVICE

	// NETWORK PROPERTY
	// 
	DEVICE_HANDLE		m_hNetworkRendererDev;							// NETWORK RENDERER DEVICE

	ULONG				m_nNetworkRendererStreamingState[ 4 ];			// NETWORK RENDERER STREAMING STATE (0 = STOP / 1 = ACQUIRE / 2 = START)
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SC2A0DLG_H__B049E8F3_88C1_4C77_B9B4_EDE24614DE52__INCLUDED_)
